uniform mat4 uniform_mtx4_wvp;
uniform mat4 uniform_mtx4_w;
uniform vec4 uniform_vec4_lightpos_scl;
uniform vec3 uniform_vec3_depth;
uniform vec4 uniform_vec4_lightcolour;
uniform vec3 uniform_vec3_txoffset;
uniform vec4 uniform_vec4_uvclip;
uniform vec4 uniform_vec4_uvoffset;

attribute vec3 attrib_position;
attribute vec4 attrib_colour;
attribute vec2 attrib_uv;

varying vec4 v_colour;
varying vec2 v_uv;
varying vec2 v_screenpos;
varying vec3 v_normal;
varying vec3 v_tangent;

void main()
{
    vec3 pos = vec3((attrib_position.xy+uniform_vec3_txoffset.xy)*uniform_vec4_lightpos_scl.zw,1.0);
    pos.xy += uniform_vec4_lightpos_scl.xy;

    vec4 outPos = uniform_mtx4_wvp * vec4(pos.xy,uniform_vec3_depth.x,1.0);
    
    gl_Position = outPos;
	v_colour    = attrib_colour*uniform_vec4_lightcolour;
       
    // From the RGB, calculate the V in HSV           
    v_colour.a  = max(uniform_vec4_lightcolour.r, max(uniform_vec4_lightcolour.g, uniform_vec4_lightcolour.b));
    
    // rescale uv's
    vec2 n_uv   = (attrib_uv - vec2(0.5,0.5))*2.0;
    n_uv        = n_uv * uniform_vec4_uvoffset.zw;
    n_uv        = (n_uv * 0.5) + vec2(0.5,0.5);
    v_uv        = n_uv + uniform_vec4_uvoffset.xy;
    
    // clip uv's      
    v_uv.x      = clamp(v_uv.x,uniform_vec4_uvclip.x,uniform_vec4_uvclip.y);
    v_uv.y      = clamp(v_uv.y,uniform_vec4_uvclip.z,uniform_vec4_uvclip.w);
        
    vec3 nrm   = mat3(uniform_mtx4_w) * vec3(1.0,0.0,0.0);
    vec3 binrm = vec3(0.0,0.0,1.0);
        
    v_screenpos   = (outPos.xy+1.0)*0.5;
    v_screenpos.y = v_screenpos.y;
    v_normal      = nrm;
    v_tangent     = cross(binrm,nrm);
}

